<h6 align="center">
    <img src="https://i.imgur.com/QpAJLql.png" width="150"/>
</h6>

<h2 align="center">
    Laravel Mail Editor (Aka MailEclipse)
</h2>

<p align="center">
<a href="https://packagist.org/packages/qoraiche/laravel-mail-editor" alt="sponsors on Open Collective"><img src="https://poser.pugx.org/qoraiche/laravel-mail-editor/v/stable" /></a> <a href="https://packagist.org/packages/qoraiche/laravel-mail-editor" alt="Sponsors on Open Collective"><img src="https://poser.pugx.org/qoraiche/laravel-mail-editor/license" /></a> 
<a href="https://packagist.org/packages/qoraiche/laravel-mail-editor" alt="Sponsors on Open Collective"><img src="https://poser.pugx.org/qoraiche/laravel-mail-editor/downloads" /></a> 
</p>
<br/><br/>

MailEclipse is a mailable editor package for your Laravel applications to create and manage mailables using a web UI. You can use this package to develop mailables without using the command line, and edit templates associated with mailables using a WYSIWYG editor, among other features.

## WORK IN PROGRESS

Please note that this package is still under active development. We encourage everyone to try it and give feedback.

## Features

* Create mailables without using command line.
* Preview/Edit all your mailables at a single place.
* Templates (more than 20+ ready to use email templates).
* WYSIWYG Email HTML/Markdown editor.
* Suitable for laravel beginners.
* Send Test mails
* Testing mails with fake data

## Requirements

| Laravel Version | Compatible version |
|-----------------|--------------------|
| 9               | Latest - [v4.x](https://github.com/Qoraiche/laravel-mail-editor/tree/v4.0.0)|
| 8               | [v3.x](https://github.com/Qoraiche/laravel-mail-editor/tree/3.x)               |
| 5.6 -> 7        | [v2.x](https://github.com/Qoraiche/laravel-mail-editor/tree/2.x)               |

## Installation

Via Composer

``` bash
$ composer require qoraiche/laravel-mail-editor
```

The package will automatically register itself.

Publish configuration file and public assets:

``` bash
php artisan laravel-mail-editor:install
```

## Documentation

### !!NOTE!! Maileclipse website is currently down, please check this youtube video (from author) for usage:

https://www.youtube.com/watch?v=QFgEGNBY3FI&t=135s


Documentation for Maileclipse can be found on the [Official website](https://maileclipse.io).

## Community

You can reach us at:

- Spectrum chat: https://spectrum.chat/maileclipse
- Slack: https://maileclipse.slack.com/


## Change log

Please see the [changelog](changelog.md) for more information on what has changed recently.

## Security

If you discover any security related issues, please email author email [qoraicheofficiel@hotmail.com](mailto:qoraicheofficiel@hotmail.com) instead of using the issue tracker.

## License

MIT license. Please see the [license file](LICENSE) for more information.

## Screenshots

![maileclipse-new-mailable](https://i.imgur.com/AiMEtY0.png)

![maileclipse-templates](https://i.imgur.com/siqxWVa.png)

![maileclipse-templates-create](https://i.imgur.com/8OQrEIS.png)

## TODO

__Contributions are welcome__

* Frontend enhancement (jquery to vue.js).
* Add more email templates (HTML/Markdown).
* Expand documentation pages.

## Credits

- [Yassine Qoraiche](https://github.com/qoraiche)
- [All Contributors](../../contributors)

## Donate :heart:

If you benefit from and/or like using MailEclipse then please help drive the future development of the project by 

* [Donating today](https://www.paypal.me/streamaps)!.
* Star the project :star:.

### Donors list:

1. **conschneider.de** - (20,00 $) - `Thank You!` - 3 November 2020
2. **Emprovise** - (20,00 $) - `You did a great job on MailEclipse! Thank you for providing this to everyone for free. I look forward to watching your project grow! Thanks Again, James S.` - 19 December 2019
3. **Idearia Web Agency** - (40,00 €) - `Keep up the good work!` - 19 June 2019
4. **Snapt Systems Ltd** - (100,00 $ USD) - `Being used by one of our teams at Snapt!` - 11 April 2019
5. **Corr Ex** - (2,00 $ USD) - 28 March 2019
6. **WebArt Design** - (10,00 $ USD) - `Donation made with love by BuiltByPanda. com from Australia who support developers and their excellent work` - 28 March 2019
7. **Flavius Borlovan** (6,99 $ USD) - `#teamcookie says HELLOO 🥳😉 Thanks for this really helpful Package (MailEclipse) bro. 😉💪🏽` - 12 March 2019
8. **Maik Kasper** - (6,99 $ USD) - `We {teamcookie:github. com/flavius-constantin} 💥 love to support good developers and their awesome work! 🌪🔥` - 13 March 2019

## Sponsors

<table>
  <tbody>
    <tr>
          <td align="center" valign="middle">
            <a href="https://www.jetbrains.com/?from=maileclipse" target="_blank">
              <img width="222px" src="https://user-images.githubusercontent.com/15586492/96636404-2c18dd00-1315-11eb-9520-736dffaaf0a7.png">
            </a>
          </td>
        </tr>
  </tbody>
</table>
