<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasTable('orders')) {

            Schema::table('orders', function (Blueprint $table) {
                if (!Schema::hasColumn('orders', 'bundle_course_id')) {
                    $table->unsignedBigInteger('bundle_course_id')->nullable()->after('bundle_id');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('bundle_course_id');
        });
    }
};
